-- author: DD ModPassion
-- copyright (C): DD ModPassion, All Rights Reserved
-- version: Farming Simulator 25
BaleManagerAddon = {} local modDirectory = string.sub(g_currentModDirectory, 0, string.len(g_currentModDirectory) - 21) local modName = g_currentModName function BaleManagerAddon.Bale_loadBaleAttributesFromXML(self, superFunc, xmlFile) superFunc(self, xmlFile) self:setMountableObjectAttributes(xmlFile:getValue("bale.mountableObject#triggerNode", nil, self.nodeId), xmlFile:getValue("bale.mountableObject#forceAcceleration", 4), xmlFile:getValue("bale.mountableObject#forceLimitScale", 1), xmlFile:getValue("bale.mountableObject#axisFreeY", false), (xmlFile:getValue("bale.mountableObject#axisFreeX", false))) self.fillTypes = {} Bale.loadFillTypesFromXML(self.fillTypes, xmlFile, self.baseDirectory) self.variations = {} local xmlBaleFile, baleDirectory = BaleManagerAddon:loadVariationsFromMod(xmlFile, self.baseDirectory) Bale.loadVariationsFromXML(self.variations, xmlBaleFile, baleDirectory) self.isRoundbale = xmlFile:getValue("bale.size#isRoundbale", true) self.width = MathUtil.round(xmlFile:getValue("bale.size#width", 0), 2) self.height = MathUtil.round(xmlFile:getValue("bale.size#height", 0), 2) self.length = MathUtil.round(xmlFile:getValue("bale.size#length", 0), 2) self.diameter = MathUtil.round(xmlFile:getValue("bale.size#diameter", 0), 2) self.centerOffsetX = 0 self.centerOffsetY = 0 self.centerOffsetZ = 0 self.uvId = xmlFile:getValue("bale.uvId", "DEFAULT") local meshes, tensionBeltMeshes = Bale.loadVisualMeshesFromXML(self.nodeId, xmlFile, self.baseDirectory) self.meshes = meshes self.tensionBeltMeshes = tensionBeltMeshes return true end function BaleManagerAddon.Bale_createDummyBale(xmlFilename, superFunc, fillTypeIndex, variationId, wrappingState, wrappingColor) superFunc(xmlFilename, fillTypeIndex, variationId, wrappingState, wrappingColor) local xmlFile = XMLFile.load("TempBale", xmlFilename, BaleManager.baleXMLSchema) local baleId = nil local baleRoot = xmlFile:getValue("bale.filename") local sharedLoadRequestId if baleRoot == nil then sharedLoadRequestId = nil else local _, baseDirectory = Utils.getModNameAndBaseDirectory(xmlFilename) local i3dFilename = Utils.getFilename(baleRoot, baseDirectory) local i3dNode i3dNode, sharedLoadRequestId = g_i3DManager:loadSharedI3DFile(i3dFilename, false, false) if i3dNode ~= 0 then baleId = getChildAt(i3dNode, 0) setRigidBodyType(baleId, RigidBodyType.NONE) unlink(baleId) local wrapping = wrappingState or 0 local meshes = Bale.loadVisualMeshesFromXML(baleId, xmlFile, baseDirectory) local fillTypes = {} Bale.loadFillTypesFromXML(fillTypes, xmlFile, baseDirectory) Bale.setFillTypeTextures(meshes, fillTypes, fillTypeIndex) local variations = {} local xmlBaleFile, baleDirectory = BaleManagerAddon:loadVariationsFromMod(xmlFile, baseDirectory) Bale.loadVariationsFromXML(variations, xmlBaleFile, baleDirectory) Bale.setVariationTextures(meshes, variations, variationId) Bale.updateVisualMeshVisibility(meshes, fillTypeIndex, wrapping > 0) Bale.updateVisualMeshWrappingState(meshes, wrapping, wrappingColor) delete(i3dNode) end end xmlFile:delete() return baleId, sharedLoadRequestId end function BaleManagerAddon:loadVariationsFromMod(xmlBaleFile, baleDirectory) if xmlBaleFile:getValue("bale.filename"):contains("$data/objects/bales/squarebales/") then baleDirectory = string.format(modDirectory.."FS25_baleTwine_addon_crossplay/") if     xmlBaleFile:getValue("bale.filename"):contains("12") then xmlBaleFile = XMLFile.load("TempBale", string.format(baleDirectory.."objects/bales/squarebales/squarebale120/squarebale120.xml"), BaleManager.baleXMLSchema) elseif xmlBaleFile:getValue("bale.filename"):contains("18") then xmlBaleFile = XMLFile.load("TempBale", string.format(baleDirectory.."objects/bales/squarebales/squarebale180/squarebale180.xml"), BaleManager.baleXMLSchema) elseif xmlBaleFile:getValue("bale.filename"):contains("22") then xmlBaleFile = XMLFile.load("TempBale", string.format(baleDirectory.."objects/bales/squarebales/squarebale220/squarebale220.xml"), BaleManager.baleXMLSchema) elseif xmlBaleFile:getValue("bale.filename"):contains("24") then xmlBaleFile = XMLFile.load("TempBale", string.format(baleDirectory.."objects/bales/squarebales/squarebale240/squarebale240.xml"), BaleManager.baleXMLSchema) end end if xmlBaleFile:getValue("bale.filename"):contains("$data/objects/bales/roundbales/") and fileExists(string.format(modDirectory.."FS25_baleNet_addon_crossplay/xmlFilename/roundbale125.xml")) then baleDirectory = string.format(modDirectory.."FS25_baleNet_addon_crossplay/") if     xmlBaleFile:getValue("bale.filename"):contains("12") then xmlBaleFile = XMLFile.load("TempBale", string.format(baleDirectory.."xmlFilename/roundbale125.xml"), BaleManager.baleXMLSchema) elseif xmlBaleFile:getValue("bale.filename"):contains("15") then xmlBaleFile = XMLFile.load("TempBale", string.format(baleDirectory.."xmlFilename/roundbale150.xml"), BaleManager.baleXMLSchema) elseif xmlBaleFile:getValue("bale.filename"):contains("18") then xmlBaleFile = XMLFile.load("TempBale", string.format(baleDirectory.."xmlFilename/roundbale180.xml"), BaleManager.baleXMLSchema) end end return xmlBaleFile, baleDirectory end function BaleManagerAddon.init() Bale.loadBaleAttributesFromXML = Utils.overwrittenFunction(Bale.loadBaleAttributesFromXML, BaleManagerAddon.Bale_loadBaleAttributesFromXML) Bale.createDummyBale = Utils.overwrittenFunction(Bale.createDummyBale, BaleManagerAddon.Bale_createDummyBale) end BaleManagerAddon.init()