--[[
Part of Production Storage Control FS25

Copyright (C) braeven 2025

Author: braeven

Important:
No modifications to this script are permitted without Braeven's permission.
You are not allowed to use part of this script without permission.
]]

local mod = g_modManager:getModByName("FS25_0_ProductionRevamp")
local loadPSC = true

if mod ~= nil then
	if g_modIsLoaded[mod.modName] then
		loadPSC = false
		print("Loading Production Storage Control was stopped, Production Revamp was detected")
	end
end

if loadPSC == true then
	source(g_currentModDirectory .. "scripts/productionStorageControl_main.lua")
	source(g_currentModDirectory .. "scripts/productionStorageControl_ingameMenue.lua")
	source(g_currentModDirectory .. "scripts/productionStorageControl_spawner.lua")
	source(g_currentModDirectory .. "scripts/productionStorageControl_settingsDialog.lua")
	source(g_currentModDirectory .. "scripts/productionStorageControl_storageDialog.lua")
	source(g_currentModDirectory .. "scripts/productionStorageControl_event_spawn.lua")
	source(g_currentModDirectory .. "scripts/productionStorageControl_changeLimits.lua")

	ProductionStorageDialog.register()
	ProductionSettingsDialog.register()
end